import { Readable } from "stream";

export interface StorageProvider {
  /**
   * Uploads a file stream and returns a unique identifier or key for the stored file,
   * along with the publicly accessible URL.
   */
  uploadStream(
    stream: Readable,
    meta: { name: string; mimeType: string; size?: number },
  ): Promise<{ identifier: string; url: string } | null>;

  /**
   * Given an identifier, deletes the file from the storage provider.
   */
  deleteFile(identifier: string): Promise<boolean>;
}
