import { S3Client } from "@aws-sdk/client-s3";
import dotenv from "dotenv";
dotenv.config();

const endpoint = process.env.IDRIVE_ENDPOINT;
const accessKeyId = process.env.IDRIVE_ACCESS_KEY_ID;
const secretAccessKey = process.env.IDRIVE_SECRET_ACCESS_KEY;
const region = process.env.IDRIVE_REGION || "eu-west-3";

if (!endpoint || !accessKeyId || !secretAccessKey) {
  console.warn(
    "⚠️ Missing IDrive configuration in environment variables. Uploads will fail.",
  );
}

export const idriveClient = new S3Client({
  region: region,
  endpoint: `https://${endpoint}`,
  credentials: {
    accessKeyId: accessKeyId || "",
    secretAccessKey: secretAccessKey || "",
  },
});

export const IDRIVE_BUCKET_NAME =
  process.env.IDRIVE_BUCKET_NAME || "file-upload";
