/*
  Warnings:

  - The `status` column on the `File` table would be dropped and recreated. This will lead to data loss if there is data in the column.
  - The `provider` column on the `File` table would be dropped and recreated. This will lead to data loss if there is data in the column.

*/
-- CreateEnum
CREATE TYPE "FileStatus" AS ENUM ('PENDING', 'DOWNLOADING', 'COMPLETED', 'FAILED');

-- CreateEnum
CREATE TYPE "Provider" AS ENUM ('R2', 'PIXELDRAIN', 'VIKINGFILE');

-- AlterTable
ALTER TABLE "File" ADD COLUMN     "pixeldrainUrl" TEXT,
ADD COLUMN     "r2Url" TEXT,
ADD COLUMN     "vikingfileUrl" TEXT,
DROP COLUMN "status",
ADD COLUMN     "status" "FileStatus" NOT NULL DEFAULT 'PENDING',
DROP COLUMN "provider",
ADD COLUMN     "provider" "Provider"[];
